﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Net;
using System.Net.Sockets;
using System.Diagnostics;
using System.Windows.Forms;

namespace 電子文書回覧追跡ツール {
    class recieveprocess {
        Form1 form;
        public recieveprocess(Form1 form) {
            this.form = form;
            setNewNameMethod = new DelegatesetNewName(setNewName);
            replaceCommentMethod = new DelegatereplaceComment(replaceComment);
            setGuidMethod = new DelegatesetGuid(setGuid);
        }

        Queue<string> que = new Queue<string>();
        System.Threading.AutoResetEvent dataEvent = new System.Threading.AutoResetEvent(false);
        IPEndPoint groupEP = new IPEndPoint(IPAddress.Any, 0);
        IPAddress[] myIP = Dns.GetHostAddresses(Dns.GetHostName());
        string rcvtext;
        string command;
        System.Threading.Thread thread1;
        bool done;

        //電文受信
        public void recieve() {
            thread1 = new System.Threading.Thread(new System.Threading.ThreadStart(this.process1));
            thread1.Start();
            done = false;
            form.udp.DontFragment = true;
            try {
                string lastrcvtext = "";
                byte[] bytes;
                while(!done) {
                    try {
                        bytes = form.udp.Receive(ref groupEP);//UDP受信待ち
                    }
                    catch(SocketException ex) {
                        if(ex.ErrorCode == 10054)
                            continue;
                        else
                            throw ex;
                    }
                    rcvtext = Encoding.UTF8.GetString(bytes, 0, bytes.Length);
                    if(OwnMessage(groupEP)) continue;//折り返し電文
                    if(form.servers.Count != 1) {//重複電文
                        if(rcvtext == lastrcvtext) {
                            continue;
                        }
                        else {
                            lastrcvtext = rcvtext;
                        }
                    }
                    System.Threading.Monitor.Enter(que);
                    {
                        que.Enqueue(rcvtext);
                        if((bool)activeflag == false) {
                            dataEvent.Set();  //処理スレッド起動
                        }
                    }
                    System.Threading.Monitor.Exit(que);
                }
            }
            catch(SocketException)// listner closeによる例外
            {
            }
            finally {
                done = true;
                dataEvent.Set();
                thread1.Join();
            }
        }

        //折り返し電文か判定
        private bool OwnMessage(IPEndPoint groupEP) {
            if(groupEP.Port != form.trackPort) {
                return false;
            }
            foreach(IPAddress myAdr in myIP) {
                if(groupEP.Address == myAdr) return true;
            }
            return false;
        }

        public void recieveclose() {
            done = true;
            form.udp.Close();
        }

        //キューを拾って処理
        object activeflag = false;
        Dictionary<string, string> Dic = new Dictionary<string, string>();
        void process1() {
            while(!done) {
                System.Threading.Monitor.Enter(que);
                if(que.Count == 0) {
                    activeflag = false;
                    System.Threading.Monitor.Exit(que);
                    dataEvent.WaitOne();
                    activeflag = true;
                    continue;
                }
                else {
                    string rectext = que.Dequeue();
                    System.Threading.Monitor.Exit(que);
                    command = rectext.Split('|')[4];
                    switch(command) {
                        //0 日時
                        //1 氏名またはUSERID
                        //2 PROGRAM区分(WATCH/TRACK/SERVER/TRANS)
                        //3 version
                        //4 COMMAND
                        //5 ～parameter1 パス
                        //6 ～parameter2 文書フォルダ名 <--- 
                        //7 ～parameter3 コメント
                        //8 ～parameter4 緊急度
                        //9 ～parameter5 ＧＵＩＤ（無い場合の考慮要）<---
                        case "putdocumentinfo": // from Server (立ち上げ時に入手する新文書名)
                            setNewName(rectext.Split('|')[6], rectext.Split('|')[7], rectext.Split('|')[8], rectext.Split('|')[9]);
                            break;
                        case "replacecomment": // from監視, from追跡
                            replaceComment(rectext.Split('|')[5], rectext.Split('|')[6], rectext.Split('|')[7], rectext.Split('|')[8]);
                            break;
                        case "statusofput":    // from Server (文書登録時に先発が居た場合)
                            MessageBox.Show(string.Format("この文書は既に{1}さんが追跡しているのでコメントと緊急度は変えずにそのままにしました。{0}{0}この後、修正機能を使用すれば変更出来ます。", Environment.NewLine, rectext.Split('|')[1]), "注意", MessageBoxButtons.OK, MessageBoxIcon.Warning);
                            setGuid(rectext.Split('|')[5], rectext.Split('|')[6], rectext.Split('|')[7], rectext.Split('|')[8], rectext.Split('|')[9]);
                            break;
                        default:
                            break;
                    }
                    Debug.Write("受信：" + rectext + Environment.NewLine);
                }
            }
        }

        //新文書名セット
        DelegatesetNewName setNewNameMethod;
        void setNewName(string doc, string comment, string priority, string guid) {
            if(this.form.InvokeRequired) {
                object[] args = { doc, comment, priority, guid };
                this.form.Invoke(setNewNameMethod, args);  //No Wait
                return;
            }
            for(int i = 0; i < this.form.dataSet2.Tables[0].Rows.Count; i++) {
                System.Data.DataRow r = this.form.dataSet2.Tables[0].Rows[i];
                if(r["guid"].ToString() == guid) {
                    //GIID一致
                    r["comment"] = comment;
                    r["priority"] = priority;
                    if(r["docfolder"].ToString() != doc) {
                        //文書名が変わっている
                        r["rename"] = r["docfolder"];
                        r["docfolder"] = doc;

                        //FileWatcher再登録
                        for(int k = 0; i < form.watcher.Count; i++) {
                            if(form.watcher[k].Path == form.folders[form.types.IndexOf(r["dockind"].ToString())]
                                && form.watcher[k].Filter == r["rename"].ToString()) {
                                try {
                                    form.watcher[k].EnableRaisingEvents = false;
                                    form.watcher[k].Filter = r["docfolder"].ToString();
                                    form.watcher[k].EnableRaisingEvents = true;
                                }
                                catch { }
                                break;
                            }
                        }
                    }
                    else {
                        //文書名は変わっていない
                        if(r["rename"].ToString() == "") {
                            //旧文書名欄が空白なので「-」印をセット
                            r["rename"] = "-";
                        }
                    }
                    break;
                }
            }
        }

        //コメント置き換え
        DelegatereplaceComment replaceCommentMethod;
        void replaceComment(string dir, string doc, string comment, string priority) {
            if(this.form.InvokeRequired) {
                object[] args = { dir, doc, comment, priority };
                this.form.Invoke(replaceCommentMethod, args);  //No Wait
                return;
            }
            List<string> dockinds = new List<string>();
            int i;
            for(i = 0; i < this.form.folders.Count; i++) {
                if(dir.StartsWith(this.form.folders[i])) {
                    dockinds.Add(this.form.types[i]); //複数の文書種類にマッチすることを考慮
                }
            }
            foreach(String dockind in dockinds) {
                bool find = false;
                for(i = 0; i < this.form.dataSet2.Tables[0].Rows.Count; i++) {
                    //lock(form.行Lock) {
                    if(this.form.dataSet2.Tables[0].Rows[i]["dockind"].ToString() == dockind && this.form.dataSet2.Tables[0].Rows[i]["docfolder"].ToString() == doc) {
                        this.form.dataSet2.Tables[0].Rows[i]["comment"] = comment;
                        this.form.dataSet2.Tables[0].Rows[i]["priority"] = priority;
                        this.form.Refresh();
                        find = true; break;
                    }
                    //}
                }
                if(find) break;
            }
        }

        //ＧＵＩＤ置き換え
        DelegatesetGuid setGuidMethod;
        void setGuid(string dir, string doc, string comment, string priority, string guid) {
            if(this.form.InvokeRequired) {
                object[] args = { dir, doc, comment, priority, guid };
                this.form.Invoke(setGuidMethod, args);  //No Wait
                return;
            }
            List<string> dockinds = new List<string>();
            int i;
            for(i = 0; i < this.form.folders.Count; i++) {
                if(this.form.folders[i].StartsWith(dir)) {
                    dockinds.Add(this.form.types[i]); //複数の文書種類にマッチすることを考慮
                }
            }
            foreach(String dockind in dockinds) {
                bool find = false;
                for(i = 0; i < this.form.dataSet2.Tables[0].Rows.Count; i++) {
                    //lock(form.行Lock) {
                    if(this.form.dataSet2.Tables[0].Rows[i]["dockind"].ToString() == dockind && this.form.dataSet2.Tables[0].Rows[i]["docfolder"].ToString() == doc) {
                        this.form.dataSet2.Tables[0].Rows[i]["comment"] = comment;
                        this.form.dataSet2.Tables[0].Rows[i]["priority"] = priority;
                        this.form.dataSet2.Tables[0].Rows[i]["guid"] = guid;
                        find = true; break;
                    }
                    //}
                }
                if(find) break;
            }
        }

    }
    delegate void DelegatesetNewName(string doc, string comment, string priority, string guid);  //デリゲート定義
    delegate void DelegatereplaceComment(string dir, string doc, string comment, string priority);  //デリゲート定義(コメント置き換え)
    delegate void DelegatesetGuid(string dir, string doc, string comment, string priority, string guid);  //デリゲート定義(GUID置き換え)
}
